﻿/*
 
C#-Programm: CalCollatz (c)2014 by www.gossmann.at
C#-Übung: T1L4
V0.9 - last mod: 091114

Aufgabenstellung:
-----------------

Eine Collatz-Folge für den Wert n ist definiert durch n -> n/2, falls n gerade ist, n -> 3n+1, falls n
ungerade ist. Die Folge ist beendet, wenn 1 erreicht ist.
Beispiel für n = 7:
7 -> 22 -> 11 -> 34 -> 17 -> 52 -> 26 -> 13 -> 40 -> 20 -> 10 -> 5 -> 16 -> 8 -> 4 -> 2 -> 1
Implementieren Sie ein Programm zur Berechnung der Collatzfolge für eine Zahl, die über Konsole
eingegeben wird.
  
Fleißaufgabe:

Abfangmaßnahme bei ungütligem Startwerten, Sicherheitsabbruch nach 500 Iterationen, Neustart-Frage

Info:
-----

zufällig herausgefunden, dass die Folge die Bit-Wertigkeiten widerspiegelt, wenn man z.B.

65536

eingibt

*/

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace CalCollatz
{
    class Program
    {
        static void Main(string[] args)
        {

        char CH_wish_JN; // dient zur abschließenden J/N-Abfrage für Neustart des Programms        
        int  lg_idx    ; // Zählindex für Anzahl der Collatz-Werte
        uint lg_calcer ; // der zu bearbeitende Collatz-Folgenwert (keine Ahnung, ob negative Werte für Collatz-Folge zugelassen sind?????? daher ein Unsigned Int)

        LB_restart_prg:

        Console.Clear(); // Platz da am Konsolen-Schirm -> Wisch- und Weg machen...

        // dem User kurze Infos zum Programm und einen Erklärungsteil präsentieren:

        Console.WriteLine ("CalCollatz V0.9a - (c) by www.gossmann.at, nov-2014:");
        Console.WriteLine                                                     (""); // Übersichtsleerzeile einstreuen...
        Console.WriteLine ("CalcCollatz berechnet die Collatz-Folge"             );
        Console.WriteLine                                                     (""); // Übersichtsleerzeile einstreuen...

        // Eingabeteil:

        Console.WriteLine("Bitte Startwert für die Collatz-Folge eingeben:");

        try
          {
          lg_calcer=Convert.ToUInt32(Console.ReadLine()) ; // zu kalkulierenden Startwert holen für die Collatz-Folge
          }

        // ungültigen Wert bei Kovertierung entdeckt (alphanumerisches Zeugs) -> durch Exception-Handler abfangen

        catch
            {
            Console.WriteLine                                                                                                         (""); // Übersichtsleerzeile einstreuen...
            Console.WriteLine ("Leider haben Sie einen ungültigen Wert eingegeben - bitte auf Kommapunkt, bzw. Leerzeichen, etc. achten!");
            goto LB_restart_select                                                                                                        ; // mittels zwar verpöntem, aber leider an der Stelle notwendigem goto Neustartabfrage durchführen
            }

        lg_idx=1; // Anzahl der Folgenwerte initialisieren

        for (;;)  // Iterationsdauer allerdings unbekannt... darum wird ja berechnet und "gebreaked" an der richtigen Stelle!
            {
            Console.WriteLine      ("Collatz-Folgenwert #" +lg_idx + ": " + lg_calcer); // Startwert ausgeben...

            if (lg_calcer==1)                                                           // ist Folgenendwert erreicht (Wert 1), bzw. war das auch schon gleich der Startwert?
               {            
               break                                                                  ; // ja -> Schleifen-Feierabend
               }

            if (lg_calcer % 2 == 0)                                                     // gerade?
               {
               lg_calcer = lg_calcer / 2                                              ; // ja -> Folgenwert entsprechend berechnen
               }
           else
              {
              lg_calcer = 3 * lg_calcer + 1                                           ; // nein, dann war´s ungerade -> Folgenwert auch dafür entsprechend berechnen
              }

           lg_idx++                                                                   ; // Iterationszähler erhöhen

           if (lg_idx > 500)                                                            // mehr als 500 Werte schon erhalten?
              {
              Console.WriteLine ("Leider hab ich nach 500 Werten keine Lust mehr..." ); // ja -> Feierabendmeldungen machen
              Console.WriteLine ("Ist wohl sowas wie PI bis zur letzten Stelle."     ); 
              break                                                                   ; // Sicherheitsabbruch einleiten (wer weiß, was User eingegeben hat und wie lange noch berechnet wird...)
              }

           }

        // Programmneustartsabfrage (es gibt Dinge, die gehen eben nur mit goto...)

        LB_restart_select:
 
        Console.WriteLine                                  (""); // Übersichtsleerzeile einstreuen...
        Console.WriteLine        ("noch eine Berechnung (j/n)");

        CH_wish_JN = Convert.ToChar (Console.ReadKey().KeyChar); // Taste holen lassen
        CH_wish_JN = char.ToLower                  (CH_wish_JN); // nur Kleinschreibung testen, damit nicht auch Großbuchstaben getestet werden müssen im Switch

        switch (CH_wish_JN)
               {
               case 'j': goto LB_restart_prg   ; // Neustart
               case 'n': return                ; // Feierabend
               default : goto LB_restart_select; // ungültige Taste gedrückt (kein j/n)
               }
       
       }
    }
}
